% performance evaluation of SS MUSIC
% Function: RMSE V.S. SNR
% Input:
% MonteIndex - name of the resulting .mat file
% Antenna_amount - number of antennas
% Repeattimes - number of Monte carlo times
% Source_number - number of sources
% a - m for coprime arrays
% b - n for coprime arrays
% Coupling_Para - coupling parameter ([0,1])

function ULAfitting_RMSE(MonteIndex,Antennanumber,Repeattimes,a,b,Source_number,coupling_parameter)
wavelength = 1; % normalized
d = wavelength / 2;
n_source = Source_number;
antenna_number = Antennanumber;
theta_bar_max = 1/3;%normalized
doas = linspace(-theta_bar_max*pi, theta_bar_max*pi, n_source);

snapshot_count = 1000;
source_count = length(doas);
       design_ana11 = ana11_1d(antenna_number, d);
       design_ana12 = ana11_1d(antenna_number, d);     
       design_nested = nested_1d(antenna_number, d);
       design_ePCA = ePCA_1d(a,b,d);
       design_supernested_2 = super_nested_1d(antenna_number, 2,d,'Super Nested Q = 2');
       design_supernested_3 = super_nested_1d(antenna_number, 3,d,'Super Nested Q = 3');
       design_MISC = MISC_1d(antenna_number, d);          
       design_ATLI_1BL = ATLI_1BL_1d(antenna_number, d);       
       design_TSENA = tsena_1d(antenna_number, d);       
       design_ATLI_2BL = ATLI_2BL_1d(antenna_number, d);       
       design_UF_3BLC1 = P3_3base_1d(antenna_number, d);      
       design_UF_4BLC1 = P2_4base_1d(antenna_number, d);       
       design_cp = coprime_1d(a,b,d);
       
    designs = { ...
    design_MISC,...
    design_UF_3BLC1,...
    design_UF_4BLC1,...
    design_nested,...
    design_supernested_2,...
    design_supernested_3,...
    design_ana11,...
    design_ana12,...
    design_ePCA,...
    design_ATLI_1BL,...
    design_ATLI_2BL,...
    design_cp,...
    design_TSENA,...
};
       
designs_number = length(designs);
repeat_times = Repeattimes;
mse_em = zeros(1, designs_number);
cur_se = zeros(1,designs_number);

power_source = 1;


mse_em = zeros(1, designs_number);
cur_se = zeros(1,designs_number);
power_noise_change_times = 9;
power_noise_record = 10.^(-linspace(-20, 20, power_noise_change_times)/10);

for ii = 1:power_noise_change_times ,ii
    power_noise = power_noise_record(ii);
    snr(ii) = 10*log10(power_source / power_noise);
    cur_se = zeros(1,designs_number);
    for rr = 1:repeat_times
        for dn = 1:designs_number
            design = designs{dn};
            [~, Coupling_Matrix,R, CL,~] = signal_considering_coupling(MonteIndex,design, doas, wavelength, snapshot_count, power_noise, power_source,coupling_parameter);    
    
            [Rss, dss] = covariance_compute_1d(design, R);%%SS music
            sp = rmusic_1d(Rss, source_count, 2*pi*design.element_spacing/wavelength,dss.element_count);%%root-MUSIC
            cur_se(dn) = cur_se(dn) + sum((sp.x_est - doas).^2);%????

        end
    end
    mse_em(ii,:) = cur_se(:) / (source_count * repeat_times);    
            
  end   
fprintf('\n');
mse_em = sqrt(mse_em);
save(['RMSE', num2str(MonteIndex), '.mat']);
end


function [X, M_C,R, CL, S ] = signal_considering_coupling(MonteIndex,design, doas, wavelength, t, ncov, scov,dd)
position_SA = design.element_indices;
position_SA = position_SA(:);
nnn = length(position_SA);
P = repmat(position_SA', nnn, 1);
D = P' - P; % D_ij = d_i - d_j
% ==================== Mutual coupling parameters ====================
c1 = dd*exp((1/3)*i*pi);
%c1 = 0;
cc=[];
cc(1)=c1;
for pp=2:100
    cc(pp) = c1*exp(-i*(pp-1)*pi/8)/pp;
end

S = 1;
% ==================== Mutual Coupling matrix computing =====================
M_C = eye(nnn);
for    ppp=1:100
       M_C( abs(D) == ppp) = cc(ppp);
end
% ==================== Coupling Leakage ================================
CL = M_C-diag(diag(M_C));
CL = norm(CL)/norm(M_C);
% ======================================================================
A = steering_matrix(design, wavelength, doas);
[m, k] = size(A);
S_internal = gen_ccsg(MonteIndex,k, t, scov);
X = M_C*A * S_internal + gen_ccsg(MonteIndex,m, t, ncov);
if nargout >= 2
    R = (X*X')/t;
    if nargout == 4
        S = S_internal;
    end
end
end


function X = gen_ccsg(MonteIndex, m, n, cov)
rng(MonteIndex+1000);
X0 = randn(m, n) + 1j * randn(m, n);
if isscalar(cov)
    X = sqrt(cov/2) * X0;
elseif isvector(cov)
    X = bsxfun(@times, X0, cov(:));
else
    C = sqrtm(cov/2);
    X = C*X0;
end
end

function [Rv, dv, z] = covariance_compute_1d(design, R)
[diffs, ~, index_map] = weight_function_1d(design);
[s, m_v, zero_idx] = get_central_ula_size(diffs);
z = zeros(s,1);
jj = 1;
for ii=zero_idx-m_v+1:zero_idx+m_v-1
    z(jj) = mean(R(index_map{ii}));
    jj = jj + 1;
end
Rv = zeros(m_v);

        for ii = 1:m_v
            Rv = Rv + z(ii:ii+m_v-1) * z(ii:ii+m_v-1)';
        end
        Rv = Rv / m_v;
dv = ula_1d(m_v, design.element_spacing, 'Virtual ULA');
end

function sp = rmusic_1d(R, n, k, mv, varargin)
%Root MUSIC for ULAs.
%Reference:
%   [1] H. L. Van Trees, Optimum array processing. New York: Wiley, 2002.
unit = 'radian';
for ii = 1:2:nargin-4
    option_name = varargin{ii};
    option_value = varargin{ii+1};
    switch lower(option_name)
        case 'unit'
            unit = option_value;
        otherwise
            error('Unknow option ''%s''.', option_name);
    end
end
m = size(R, 1);

if n >= m
    error('Too many sources.');
end

% root MUSIC
[E, l] = eig(R, 'vector');
if isreal(l)
    En = E(:,1:end-n);
else
    [~, idx] = sort(abs(l));
    En = E(:,idx(1:end-n));
end

  derad = pi/180;
  twpi = 2*pi;
  for iang = 1:361*5
        angle(iang)=(iang-181)/2;
        phim=derad*angle(iang);
        m_v = (mv-1)/2;
        d = 0:0.5:m_v;
        a=exp(-j*twpi*d*sin(phim)).';
        %L=iwave;    
        %En=EV(:,L+1:kelm);
        SP(iang)=(a'*a)/(a'*En*En'*a);
  end
   
% 
SP=abs(SP);


C = En*En';
coeff = zeros(m - 1, 1);
for ii = 1:m-1
    coeff(ii) = sum(diag(C, ii));
end
coeff = [flipud(coeff); sum(diag(C)); conj(coeff)];
% solve
z = roots(coeff)'; % roots returns a column vector
% find n points inside the unit circle that are also closest to the unit
% circle
nz = length(z);
mask = true(nz, 1);
for ii = 1:nz
    absz = abs(z(ii));
    if absz > 1
        mask(ii) = false;
    elseif absz == 1
        % find the closest point and remove it
        idx = -1;
        dist = inf;
        for jj = 1:nz
            if jj ~= ii && mask(jj)
                cur_dist = abs(z(ii) - z(jj));
                if cur_dist < dist
                    dist = cur_dist;
                    idx = jj;
                end
            end
        end
        mask(idx) = false;
    end
end
z = z(mask);
[~, idx] = sort(1 - abs(z));
%}

sp = struct();
sp.x_est = sort(-cm2doa(z(idx(1:n)), k, unit));
sp.x = sp.x_est;
sp.x_unit = unit;
%sp.y = ones(1, n);
sp.y = SP;
sp.theta = angle;
sp.resolved = true;
sp.discrete = true;
end

function design = ATLI_2BL_1d(n, d, ATLI_2BL)
% ========= array configuration ============
% ========= decide spacing
sn_1 = 2;
n_1 = floor((n+2)/6);
n_3 = n_1-1;
n_5 = n_3;
sn_4 = 4 * n_1 ;
sn_3 = 2 * n_1 - 1;
sn_5 = 2 * n_1 + 1;
sn_2 = 2;
n_2 = 2;
sn_6 = 2;
n_6 = n_1;
n_4 = n - 4*n_1;

interspace_12 = 1;
i_2 = sn_1 * (n_1-1) + interspace_12;
%%%%%%%%%%%%%%%%%%%%
interspace_23 = (n_1-1)*2-1;
i_3 = i_2 + (n_2-1)*sn_2 + interspace_23 ;
%%%%%%%%%%%%%%%%%%%%
interspace_34 = sn_3 ;
i_4 = i_3 + (n_3-1)*sn_3 + interspace_34;
%%%%%%%%%%%%%%%%%%%%
interspace_45 = sn_5;
i_5 = i_4 + (n_4-1)*sn_4 + interspace_45;
%%%%%%%%%%%%%%%%%%%%
interspace_56 = 2*n_1 + 1;
i_6 = i_5 + (n_5-1)*sn_5 + interspace_56;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub1 = [];
for sub1_count = 1:n_1
    sub1(sub1_count) = 0 + (sub1_count-1)*sn_1;
end

sub2 = [];
for sub2_count = 1:n_2
    sub2(sub2_count) = 0 + (sub2_count-1)*sn_2;
end
sub2 = sub2+i_2;
sub3 = [];
for sub3_count = 1:n_3
    sub3(sub3_count) = 0 + (sub3_count-1)*sn_3;
end
sub3 = sub3+i_3;
%%%%%%%%%%%%%%%%%%%%%%%%%
sub4 = [];
for sub4_count = 1:n_4
    sub4(sub4_count) = 0 + (sub4_count-1)*sn_4;
end
sub4 = sub4+i_4;
%%%%%%%%%%%%%%%%%%%%%%%%%%
sub5 = [];
for sub5_count = 1:n_5
    sub5(sub5_count) = 0 + (sub5_count-1)*sn_5;
end
sub5 = sub5+i_5;
%%%%%%%%%%%%%%%%%%%%%%%%%%
sub6 = [];
for sub6_count = 1:n_6
    sub6(sub6_count) = 0 + (sub6_count-1)*sn_6;
end
sub6 = sub6+i_6;
%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin <= 2
    name = sprintf('ATLI-2BL %d sensors', n);
end
design.element_indices = [sub1 sub2 sub3 sub4 sub5 sub6];
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'ATLI-2BL';
design.name = name;
end

function [A, DA] = steering_matrix(design, wavelength, doas)

DA = [];

doas = reshape(doas, 1, []);  

A = exp(2j*pi/wavelength*(design.element_positions' * sin(doas)));

end

function [DCAs, weight_func, position_index] = weight_function_1d(design)
position_SA = design.element_indices(:);
DCAs = [];
weight_func = [];
position_index = {};
n = length(position_SA);
P = repmat(position_SA', n, 1);
D = P' - P; 
[all_diffs, idx] = sort(D(:));
cur_diff = all_diffs(1);
start_idx = 1;
jj = 1;
for ii = 2:(n*n)
    if all_diffs(ii) ~= cur_diff
        DCAs(jj) = cur_diff;
        position_index{jj} = idx(start_idx:ii-1);
        weight_func(jj) = ii - start_idx;
        start_idx = ii;
        cur_diff = all_diffs(ii);
        jj = jj + 1;
    end
end
DCAs(jj) = cur_diff;
position_index{jj} = idx(start_idx:end);
weight_func(jj) = n*n - start_idx + 1;
end

function [s, m_v, zero_idx] = get_central_ula_size(diffs)

if isstruct(diffs)
    diffs = unique_differences(diffs.element_indices);
end

w = 0;
zero_idx = find(diffs == 0);
n_diff = length(diffs);
while zero_idx + w < n_diff && zero_idx - w > 1
    w = w + 1;
    if (diffs(zero_idx+w) - diffs(zero_idx+w-1) ~= 1) || (diffs(zero_idx-w+1) - diffs(zero_idx-w)) ~= 1
        w = w - 1;
        break;
    end
end
m_v = w + 1;
s = 2*m_v - 1;

end

function design = ula_1d(n, d, name)

if nargin <= 2
    name = sprintf('ULA with %d elements', n);
end
design.element_indices = (0:n-1);
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = n;
design.dim = 1;
design.type = 'ula';
design.name = name;
end

function doa = cm2doa(z, k, unit)
%CM2DOA Converts complex exponentials to doas.
switch lower(unit)
    case 'radian'
        doa = asin(angle(z) / k);
    case 'degree'
        doa = rad2deg(asin(angle(z) / k));
    case 'sin'
        doa = angle(z) / k;
    otherwise
        error('Unkown unit ''%s''.', unit);
end
end

function design = P3_3base_1d(k, d, UF_3BLC1)

n = floor((k-5)/6);
m = k-3*n-4;

num_array = 6;
mid_count = ceil((1+num_array)/2)-1;
sn_1 = 3;
sn_2 = 1;
n_1 = n;
sn_3 = 3 * n_1+5;
sn_4 = 3;
sn_6 = 3;
sn_5 = 2;
%%%%%%%%%%%%%%%%%%%%%%
n_2 = 2;
n_5 = 2;
n_3 = m;
n_4 = n_1;
n_6 = n_1;
%%%%%%%%%%%%%%%%%%%%%%
interspace_12 = 4;
interspace_23 = 2+3*(n_1);
interspace_34 = sn_4;
interspace_45 = 4;
interspace_56 = 3;


% ========= subarray designs ===========
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute initial position   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    if initial_count==1
        eval(['i_',num2str(initial_count),'=0',';'])
    else 
        eval(['i_',num2str(initial_count),'=i_',num2str(initial_count-1),'+(n_',num2str(initial_count-1),'-1)*sn_',num2str(initial_count-1),'+interspace_',num2str(initial_count-1),num2str(initial_count),';'])
    end 
end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute sub arrays   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    eval(['sub',num2str(initial_count),'=[]',';'])
    eval(['count1=n_',num2str(initial_count),';'])
    for sub_count=1:count1
        eval(['sub',num2str(initial_count),'(sub_count) = (sub_count-1)','*sn_',num2str(initial_count),';'])
    end
    eval(['sub',num2str(initial_count),'=sub',num2str(initial_count),'+i_',num2str(initial_count),';'])
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% compute array address  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
arr_indices = [];
for p = 1:num_array
    eval(['arr_indices = [ arr_indices sub',num2str(p),'];'])
end
%%%%%%%%%%%%%%%%%%%%%%%%%



if nargin <= 2
    name = sprintf('UF_3BLC1 %d sensors', k);
end
design.element_indices = arr_indices;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'UF_3BLC1';
design.name = name;
end

function design = P2_4base_1d(k, d, UF_4BLC1)
% ========= array configuration ============
% ========= decide spacing
n = floor((k-8)/8);
m = k-4*n-6;
%%%%%%%%%%%%%%%
num_array = 8;
mid_count = ceil((1+num_array)/2);
sn_1 = 3;
sn_2 = 4;
sn_3 = 1;
sn_4 = sn_2;
n_2 = n;%%n>=2
sn_5 = sn_2*(n_2) + 7;
sn_6 = sn_2;
sn_7 = 2;
sn_8 = sn_2;


%%%%%%%%%%%%%%%%%%%
n_1 = 2;
n_3 = 2;
n_7 = 2;
n_4 = n_2;
n_5 = m;
n_6 = n_2;
n_8 = n_2;

%%%%%%%%%%%%%%%%%%%
interspace_12 = 4; 
interspace_23 = 5; 
interspace_34 = 6; 
interspace_45 = 8; 
interspace_56 = 7; 
interspace_67 = 3; 
interspace_78 = 5;
% ========= subarray designs ===========
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute initial position   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    if initial_count==1
        eval(['i_',num2str(initial_count),'=0',';'])
    else 
        eval(['i_',num2str(initial_count),'=i_',num2str(initial_count-1),'+(n_',num2str(initial_count-1),'-1)*sn_',num2str(initial_count-1),'+interspace_',num2str(initial_count-1),num2str(initial_count),';'])
    end 
end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute sub arrays   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    eval(['sub',num2str(initial_count),'=[]',';'])
    eval(['count1=n_',num2str(initial_count),';'])
    for sub_count=1:count1
        eval(['sub',num2str(initial_count),'(sub_count) = (sub_count-1)','*sn_',num2str(initial_count),';'])
    end
    eval(['sub',num2str(initial_count),'=sub',num2str(initial_count),'+i_',num2str(initial_count),';'])
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% compute array address  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
arr_indices = [];
for p = 1:num_array
    eval(['arr_indices = [ arr_indices sub',num2str(p),'];'])
end
%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin <= 2
    name = sprintf('UF-4BLC1 %d sensors', k);
end
design.element_indices = arr_indices;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'UF-4BLC1';
design.name = name;
end

function design = MISC_1d(n, d, MISC)
%MISC_1D Generates a 1D MISC array.
%Syntax:
%   design = MISC_1d(n, wavelength/2, 'MISC Array');
%Inputs:
%   n - sensor amount.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'MISC array (m)'.
%Outputs:
%   design - An array design struct.

% ========= array configuration ============
% ========= decide spacing
q = floor((n)/4);
S_n = 2*q+2;
% ========= subarray designs ===========
% ========= initial parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub1=[0 1];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub2=[];
for sub2_count = 1:(n-S_n)
    sub2(sub2_count)= 0 + (sub2_count-1)*S_n;
end
sub2 = sub2 + S_n - 2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub3=[];

for sub3_count = 1:((S_n-4)/2 + 1)
    sub3(sub3_count)= 0 + (sub3_count-1)*2;
end
sub4 = sub3;
sub3 = sub3 + (n-S_n+1)*S_n-2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub4 = sub4 + (n-S_n+2)*S_n-3;
if nargin <= 2
    name = sprintf('MISC array %d sensors', n);
end
design.element_indices = [sub1 sub2 sub3 sub4];
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'MISC';
design.name = name;
end

function design = ana11_1d(n, d, ANAI1)
%ana11_1d Generates a 1D ANAI-1 array.
%Syntax:
%   design = ana11_1d(n, wavelength/2, 'ANAI-1 Array');
%Inputs:
%   n - Parameter pair.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'ANAI-1 array (m, n)'.
%Outputs:
%   design - An array design struct.

% ========= array configuration ============
% ========= decide spacing
if mod(n,2)==1
    n1 = (n-1)/2;
else
    n1 = n/2;
end
n2 = n-n1;
L1 = ceil((n1 +1)/2);
V22 = [];
V22 = [0:L1];
V21 = [];
V21 = [0 L1+1:n1];
L=[];
LEN_V21 = length(V21);
for left_count = 1:LEN_V21
    L(left_count)=n1+1-V21(left_count);
end
%L=sort(L);
R=[];
LEN_V22 = length(V22);
for right_count = 1:LEN_V22
    R(right_count)=V22(right_count) + (n1+1)*n2;
end
M=[];
for middle_count = 1:n2
    M(middle_count) = middle_count*(n1+1);
end

if nargin <= 2
    name = sprintf('ANAI-1 %d sensors', n);
end
A = [L M R];
A = unique(A);
A = sort(A);
design.element_indices = A;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'ANAI-1';
design.name = name;
end

function design = ana12_1d(n, d, ANAI2)
%ana12_1d Generates a 1D ANAI-2 array.
%Syntax:
%   design = ana12_1d(n, wavelength/2, 'ANAI-2 Array');
%Inputs:
%   n - Parameter pair.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'ANAI-2 array (m, n)'.
%Outputs:
%   design - An array design struct.
% ========= array configuration ============
% ========= decide spacing
if mod(n,2)==1
    n1 = (n-1)/2;
else
    n1 = n/2;
end
n2 = n-n1;
k1 = [];
k1 = [0:floor((n1-1)/2)];
k2 = [];
k2 = [1:floor(n1/2)];

L1 = ceil((n1 +1)/2);
V22 = [];
LEN_k2 = length(k2);
for V22_count = 1:LEN_k2
    V22(V22_count) = n1 - 2*k2(V22_count);
end
V22 = [0 V22];
V21 = [];
LEN_k1 = length(k1);
for V21_count = 1:LEN_k1
    V21(V21_count) = n1 - 2*k1(V21_count)-1;
end
V21 = [0 n1 V21];
L=[];
LEN_V21 = length(V21);
for left_count = 1:LEN_V21
    L(left_count)=n1+1-V21(left_count);
end
%L=sort(L);
R=[];
LEN_V22 = length(V22);
for right_count = 1:LEN_V22
    R(right_count)=V22(right_count) + (n1+1)*n2;
end
M=[];
for middle_count = 1:n2
    M(middle_count) = middle_count*(n1+1);
end

if nargin <= 2
    name = sprintf('ANAI-2 %d sensors', n);
end
A = [L M R];
A = unique(A);
A = sort(A);
design.element_indices = A;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'ANAI-2';
design.name = name;
end

function design = nested_1d(k, d, name)
%NESTED_1D Generates a 1D nested array.
%Inputs:
%   k - Total number of sensors.
%   d - Inter-element spacing..
%Outputs:
%   design - An array design struct.
n1 = floor(k/2);
n2 = k-n1;

if nargin <= 2
    name = sprintf('Nested (%d, %d)', n1, n2);
end
design.element_indices = union(1:n1, (n1+1)*(1:n2)) - 1;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'nested';
design.name = name;
end

function design = super_nested_1d(k, Q,d, name)
N1 = floor(k/2);
N2 = k - N1;
    if (Q == 1)
        % >>>>>>>>>>>>>>>>>>>> Nested arrays <<<<<<<<<<<<<<<<<<<<
        % Please see [5].
        % [5] P. Pal and P. P. Vaidyanathan, Nested arrays: A novel approach to array processing with enhanced degrees of freedom,?IEEE Trans. Signal Process., vol. 58, no. 8, pp. 4167?181, Aug 2010.
        S = [	1 : N1, ... % Dense ULA
				(1:N2)*(1+N1)].'; % Sparse ULA
    elseif (Q == 2)
        % >>>>>>>>>>>>>>>>>>>> Second-order super-nested arrays <<<<<<<<<<<<<<<<<<<<
        % Please see [1,3].
        % Generate (A1, B1, A2, B2) according to N1
        switch (mod(N1, 4))
            case 0
                r = N1 / 4;
                A1 = r; B1 = r - 1; A2 = r - 1; B2 = r - 2;
            case 1
                r = (N1 - 1) / 4;
                A1 = r; B1 = r - 1; A2 = r - 1; B2 = r - 1;
            case 2
                r = (N1 - 2) / 4;
                A1 = r + 1; B1 = r - 1; A2 = r; B2 = r - 2;
            case 3
                r = (N1 - 3)/4;
                A1 = r; B1 = r; A2 = r; B2 = r - 1;
            otherwise
                error('Error');
        end
        S = [   1 + 2 * (0 : A1), ...                   % X_1^{(Q)}
                (N1 + 1) - (1 + 2 * (0 : B1)), ...      % Y_1^{(Q)}
                (N1 + 1) + (2 + 2 * (0 : A2)), ...      % X_2^{(Q)}
                2 * (N1 + 1) - (2 + 2 * (0 : B2)), ...  % Y_2^{(Q)}
                (N1 + 1) * (2 : N2), ...                % Z_1^{(Q)}
                N2 * (N1 + 1) - 1                       % Z_2^{(Q)}
             ];
        S = sort(unique(S)).';
       % S1 = S;
    else
        % >>>>>>>>>>>>>>>>>>>> Qth-order super-nested arrays <<<<<<<<<<<<<<<<<<<<
        % Please see [2,4].
        if ( mod(N1, 2) == 0)
            % N1 is EVEN
            S1 = super_nested_1d(k,2,d ,'super' );
            S=S1.element_indices;
            % Determine the cutoff between X_1^{(Q)} and Y_1^{(Q)}
            for nn = 1 : length(S)-1
                if (S(nn+1) - S(nn) == 1)
                    X = S(nn);
                    break;
                end
            end
            for q = 3 : Q
                % Select X_q^{(q)} and Y_q^{(q)}
                index_XQ = (S > (q-2)*(N1+1) & S <= (q-2)*(N1+1) + X);
                index_YQ = (S > (q-2)*(N1+1) + X & S < (q-1)*(N1+1));
                XQ = S( index_XQ );
                YQ = S( index_YQ );
                if (length(XQ) >= 3 && length(YQ) >= 3)
                    if ( mod(length(XQ), 2) == 0 )
                        % With extra term
                        XQ( 2 : 2 : end-2 ) = XQ( 2 : 2 : end-2 ) + (N1+1);
                    else
                        % No extra term
                        XQ( 2 : 2 : end-1 ) = XQ( 2 : 2 : end-1 ) + (N1+1);
                    end
                    
                    if ( mod(length(YQ), 2) == 0 )
                        % With extra term
                        YQ( end-1 : -2 : 3 ) = YQ( end-1 : -2 : 3 ) + (N1+1);
                    else
                        % No extra term
                        YQ( end-1 : -2 : 2 ) = YQ( end-1 : -2 : 2 ) + (N1+1);
                    end
                    S( S == (q-1)*(N1+1) ) = (N2 + 1 - (q - 1)) * (N1 + 1) - 2^(q-1) + 1;
                    S( index_XQ ) = XQ;
                    S( index_YQ ) = YQ;
                else
                    disp(['Only up to order-', num2str(q-1), ' is defined. Return the ', num2str(q-1), 'th-order super nested array'])
                    break;
                end
            end
            
            % Sort S
            S = sort(unique(S));
        else
            % N1 is ODD
            % Check Q satisfies our conditions or not
            if (N1 < 3 * 2^Q - 1 || N2 < 3 * Q - 4)
                disp('Warning! The resultant super-nested array might not be a restricted array!')
            end
            S = [];
            for q = 1 : Q - 1
                ell = 0 : floor(((N1 + 1) / 2^q - 1) / 2);
                S = [S,	(q - 1) * (N1 + 1) + 2^(q - 1) + 2^q * ell, q * (N1 + 1) - 2^(q - 1) - 2^q * ell, ...
                        (N2 + 1 - q) * (N1 + 1) - 2^q + 1];
            end
            ell = 0 : floor( (N1 + 1) / 2^Q - 1 );
            S = [S, (Q - 1) * (N1 + 1) + 2^(Q - 1) + 2^(Q - 1) * ell, Q * (N1 + 1) - 2^(Q - 1) - 2^(Q - 1) * ell];
            S = [S, (N1 + 1) * (Q : N2)];
            S = sort(unique(S)).';
            S = S';
        end
    end



if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('Super Nested Array Q=( %d)',  Q);
elseif ~ischar(name)
    error('Name must be a string.');
end
if Q>2
    S=S';
end
c=num2str(Q);
design.element_indices = S';
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = c;
design.name = name;
end

function design = tsena_1d(n, d, TSENA)
%TSENA_1D Generates a 1D TSENA array.
%Syntax:
%   design = tsena_1d(n, wavelength/2, 'TSENA');
%Inputs:
%   n - Parameter pair.
%   d - Inter-element spacing.
% ========= array configuration ============
% ========= decide spacing
n1 = 2*floor((n+3)/4);
n2 = n-n1-1;
l = (n1)/2;
R11 = [];
R11 = [0 l 2*l 2*l+3:3*l];
R12 = [];
R12 = [0 l+1 2*l+2 3*l+3:4*l];
L=[];
LEN_R11 = length(R11);
for left_count = 1:LEN_R11
    L(left_count)=n1+1-R11(left_count);
end
L=sort(L);
R=[];
LEN_R12 = length(R12);
for right_count = 1:LEN_R12
    R(right_count)=R12(right_count) + (n1+1)*(n2+1);
end
M=[];
for middle_count = 1:n2
    M(middle_count) = middle_count*(n1+1);
end

if nargin <= 2
    name = sprintf('TSENA %d sensors', n);
end
A = [L M R];
A = unique(A);
A = sort(A);
design.element_indices = A;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'TSENA';
design.name = name;
end

function design = coprime_1d(m, n, d)
%COPRIME_1D Generates a 1D co-prime array.
%Inputs:
%   m - Co-prime number pair.
%   n - Co-prime number pair.
%   d - Inter-element spacing.
name = sprintf('Co-prime array (%d, %d)', m, n);
cp = [(0:n-1) * m (1:2*m-1) * n];
design.element_indices = cp;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'co-prime';
design.name = name;
end

function design = ePCA_1d(m, n, d, ePCA)
L_cadis1 = [0:m:(n-1)*m];
L_cadis21 = [m*n+m+n:n:m*n+m+n+n*(2*m-2-floor(m/2))];
P_31=[m*n-n*(floor(m/2)-1):n:m*n-n];
P_32 = m*n-m-floor(m/2)*n;
P_3 = [P_31 P_32];

% ========= subarray designs ===========
% ========= initial parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
add = [L_cadis1 L_cadis21 P_3];
arr_indices = sort(add);

if nargin <= 3
    name = sprintf('ePCA array %d sensors', n);
end
design.element_indices = arr_indices;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'ePCA';
design.name = name;
end

function design = ATLI_1BL_1d(n, d, ATLI_1BL)
% ========= array configuration ============
% ========= decide spacing
n_1 = floor((n+4)/6);
n_3 = n + 2 - 4*n_1;
sn_1 = 1;
%n_1 = 4;
sn_2 = 2 * n_1 - 1;
sn_3 = 2 * sn_2 + 1;
sn_4 = sn_2 + 1;
sn_5 = 1;
%%%%%%%%%%%%%%
n_2 = n_1 - 1;
interspace_12 = sn_1 * n_1;
i_2 = sn_1*(n_1-1) + interspace_12;
%%%%%%%%%%%%%%

interspace_23 = sn_2;
i_3 = i_2 + (n_2-1)*sn_2 + interspace_23;
%%%%%%%%%%%%%%
n_4 = n_2;
interspace_34 = sn_4;
i_4 = i_3 + (n_3-1)*sn_3 + interspace_34;
%%%%%%%%%%%%%%
n_5 = n_1;
interspace_45 = sn_4;
i_5 = i_4 + (n_4-1)*sn_4 + interspace_45;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub1 = [];
for sub1_count = 1:n_1
    sub1(sub1_count) = 0 + (sub1_count-1)*sn_1;
end

sub2 = [];
for sub2_count = 1:n_2
    sub2(sub2_count) = 0 + (sub2_count-1)*sn_2;
end
sub2 = sub2+i_2;
sub3 = [];
for sub3_count = 1:n_3
    sub3(sub3_count) = 0 + (sub3_count-1)*sn_3;
end
sub3 = sub3+i_3;
%%%%%%%%%%%%%%%%%%%%%%%%%
sub4 = [];
for sub4_count = 1:n_4
    sub4(sub4_count) = 0 + (sub4_count-1)*sn_4;
end
sub4 = sub4+i_4;
%%%%%%%%%%%%%%%%%%%%%%%%%%
sub5 = [];
for sub5_count = 1:n_5
    sub5(sub5_count) = 0 + (sub5_count-1)*sn_5;
end
sub5 = sub5+i_5;

if nargin <= 2
    name = sprintf('ATLI-1BL %d sensors', n);
end
design.element_indices = [sub1 sub2 sub3 sub4 sub5];
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'ATLI-1BL';
design.name = name;
end


